class Proj_EliteBrutie extends Projectile;

function PostBeginPlay()
{
	if ( ScriptedPawn(Instigator) != None )
		Speed = ScriptedPawn(Instigator).ProjectileSpeed;
	Velocity = Vector(Rotation) * speed;
	PlaySound(SpawnSound,SLOT_None,4.0);
	Super.PostBeginPlay();
} 

function MakeSound()
{
	PlaySound(ImpactSound, SLOT_Interact);
	MakeNoise(1.0);
}

simulated function Explode(vector HitLocation, vector HitNormal)
{
	local SmokeColumn s;

	MakeSound();
 	s = spawn(class'SmokeColumn',,,Location+Vect(0,0,38));
	s.RemoteRole = ROLE_None;
	destroy();
}
	

auto state Flying
{
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		local vector momentum;
	
		if ( (Krall(Other) == None) && (KraalBolt(Other) == None))
		{
			if ( Role == ROLE_Authority )
			{
				momentum = MomentumTransfer * Normal(Velocity);
				Other.TakeDamage( Damage, instigator, HitLocation, momentum, 'zapped');
			}
			Destroy();
		}
	}

Begin:
	Sleep(7.0); //self destruct after 7.0 seconds
	Explode(Location, vect(0,0,0));
}

defaultproperties
{
     speed=1400.000000
     MaxSpeed=1400.000000
     Damage=25.000000
     MomentumTransfer=10000
     SpawnSound=Sound'UnrealI.Krall.Krasht2'
     RemoteRole=ROLE_SimulatedProxy
     LifeSpan=7.500000
     Mesh=LodMesh'UnrealI.Krallbm'
     AmbientGlow=255
     bUnlit=True
     LightType=LT_Steady
     LightEffect=LE_NonIncidence
     LightBrightness=200
     LightHue=255
     LightSaturation=127
     LightRadius=4
     MultiSkins(0)=FireTexture'UnrealShare.Effect1.FireEffect1p'
     MultiSkins(1)=FireTexture'UnrealShare.Effect1.FireEffect1ob'
}
